;;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10 -*-

;;; appleII.asd 
;;; 
;;; A system containing routines to support hacking on Apple II systems
;;;

(in-package asdf)
(defsystem :appleII
  :name "appleII"
  :author "Joseph Oswald <josephoswald@gmail.com>"
  :version "0.5"
  :maintainer "Joseph Oswald <josephoswald@gmail.com>"
  :licence "Not licensed."
  :description "Apple II Hacking Library"
  :long-description "The appleII package provides routines to interpret Apple II disk images and 
disassemble Apple II code."
  :perform (load-op :after (op appleII)
		    (pushnew :appleII cl:*features*))
  :components ((:file "circular-sequence")
	       (:file "dskimage")
	       (:file "diskcopy_image" :depends-on ("dskimage"))
	       (:file "nibimage") ; only calls routines in  :depends-on "circular-sequence")
	       (:file "applesoft")
	       (:file "disasm6502")
	       (:file "asm6502" :depends-on ("disasm6502"))
	       (:file "disasm6502-oo"
		      :depends-on ("disasm6502"))))
